<?php

/**

 * @package SB Admin Theme

 */

/*

Plugin Name: SB Admin Theme

Plugin URI: http://smithbates.com

Description: Custom Admin Settings.

Version: 1

Author: SmithBates

Author URI: http://smithbates.com


*/


//Load Scripts and Styles
function sb_admin_init() {

		wp_enqueue_style( 'sb-admin-style', plugins_url('sb.css',__FILE__ ) );
		
		//Admin Bar
		if (!current_user_can('edit_posts')) {
			
			show_admin_bar(false);
			remove_action( 'wp_head', '_admin_bar_bump_cb' );
			
			//Lock profile edits
			global $pagenow;
    		if($pagenow == 'profile.php') {
				header('Location: '.get_bloginfo( 'url' ));exit;	
			}
		}
		
		
}

add_action( 'admin_init', 'sb_admin_init' );
add_action( 'wp_enqueue_scripts', 'sb_admin_init' );

// Remove admin menu items
function sb_clean_admin_menu() {
	if(!current_user_can('switch_themes')) {
			remove_menu_page( 'edit-comments.php') ;
			remove_menu_page( 'profile.php') ;
			remove_menu_page( 'tools.php') ;
			remove_submenu_page( 'themes.php', 'themes.php' ) ;
			//remove_submenu_page( 'themes.php', 'widgets.php' ) ;
			remove_submenu_page( 'themes.php', 'customize.php' ) ;
	}
}

add_action('admin_menu', 'sb_clean_admin_menu');

function remove_admin_bar_links() {
	if(!current_user_can('switch_themes')) {
		global $wp_admin_bar;
		$wp_admin_bar->remove_menu('themes'); 
		$wp_admin_bar->remove_menu('customize'); 
		//$wp_admin_bar->remove_menu('widgets'); 
		$wp_admin_bar->remove_menu('header');
		$wp_admin_bar->remove_menu('new-user');
	}
}
add_action( 'wp_before_admin_bar_render', 'remove_admin_bar_links' );

// End of admin links

add_filter( 'gettext', 'change_howdy_text', 10, 2 );
function change_howdy_text( $translation, $original ) {
    if( 'Howdy, %1$s' == $original )
        $translation = 'Logged in as %1$s';
    return $translation;
}

function sb_login_logo() { ?>
    <style type="text/css">
		
		body.login div#login h1 a {
			/*background: url(<?php echo plugins_url('/img/sb_logo.png',__FILE__ ) ?>) no-repeat center top transparent !important;*/
			background-image:url(<?php echo plugins_url('/img/sb_logo.png',__FILE__ ) ?>);
			background-size: 274px auto;
			width:100%;
		}
		
		#backtoblog, #nav, .forgetmenot {
			display:none;	
		}
		
		
    </style>
<?php }
add_action( 'login_enqueue_scripts', 'sb_login_logo' );


//Clean Dashboard
function remove_dashboard_widgets() {
 	remove_meta_box( 'dashboard_incoming_links', 'dashboard', 'normal' );
	remove_meta_box( 'dashboard_browser_nag', 'dashboard', 'normal' );
	remove_meta_box( 'dashboard_right_now', 'dashboard', 'normal' );
	remove_meta_box( 'dashboard_recent_comments', 'dashboard', 'normal' );
	remove_meta_box( 'dashboard_plugins', 'dashboard', 'normal' );
	remove_meta_box( 'dashboard_recent_drafts', 'dashboard', 'side' );
	remove_meta_box( 'dashboard_quick_press', 'dashboard', 'side' );
	remove_meta_box( 'dashboard_primary', 'dashboard', 'side' );
	remove_meta_box( 'dashboard_secondary', 'dashboard', 'side' );
	
	wp_add_dashboard_widget( 'dashboard_sb_recent_drafts', __('Recent Drafts'), 'wp_dashboard_recent_drafts' );
} 
 
add_action('wp_dashboard_setup', 'remove_dashboard_widgets' );





//Modify Footer
function sb_footer_admin ()
{
    echo '<span id="footer-thankyou">SmithBates</span>';
}
add_filter('admin_footer_text', 'sb_footer_admin');





//Redirect Login

function sb_login_redirect($redirect_to, $request) {
$redirect_url = get_bloginfo( 'url' );

return $redirect_url;
}
//add_filter("login_redirect", "sb_login_redirect", 10, 3);

function loginpage_custom_link() {
	return get_bloginfo( 'url' );
}
add_filter('login_headerurl','loginpage_custom_link');

function change_title_on_logo() {
	return 'Home';
}
add_filter('login_headertitle', 'change_title_on_logo');


