<?php 
/**

 * @package SB contact Form

 */

/*

Plugin Name: SB Contact Form

Plugin URI: http://smithbates.com

Description: Custom contact form.

Version: 1

Author: SmithBates

Author URI: http://smithbates.com

License: GPLv2 or later

*/


//SB Contact frontend

function sbContact_function( $atts ){
	wp_enqueue_style('jquery-style', 'https://ajax.googleapis.com/ajax/libs/jqueryui/1.8.2/themes/smoothness/jquery-ui.css');
	wp_enqueue_script( 'sbContact-validate', plugins_url('includes/jquery.validate.min.js',__FILE__ ));
	wp_enqueue_style( 'sbContact-style', plugins_url('includes/form.css?v=3',__FILE__ ));
	add_action( 'wp_footer', 'sb_contact_admin_javascript' );
	ob_start();
	include('includes/form.php');
	$output = ob_get_clean();
	return $output;
}
add_shortcode( 'sb_contact_form', 'sbContact_function' );

function sbPopContact_function( $atts ){
	global $_COOKIE;
	//if(!isset($_COOKIE['popcontact'])) add_action('init','pop_cookie');
	if(isset($_COOKIE['popcontact']) && $_COOKIE['popcontact'] == 't') {
		wp_enqueue_style('jquery-style', 'https://ajax.googleapis.com/ajax/libs/jqueryui/1.8.2/themes/smoothness/jquery-ui.css');
		wp_enqueue_script( 'sbContact-validate', plugins_url('includes/jquery.validate.min.js',__FILE__ ));
		wp_enqueue_script( 'sbContact-cookie', plugins_url('includes/jquery-cookie.js',__FILE__ ));
		wp_enqueue_style( 'sbContact-style', plugins_url('includes/form.css?v=3',__FILE__ ));
		add_action( 'wp_footer', 'sb_contact_admin_javascript' );
		ob_start();
		include('includes/pop_form.php');
		$output = ob_get_clean();
	}
	
	return $output;
}
add_shortcode( 'sb_pop_contact_form', 'sbPopContact_function' );

function pop_cookie() {
	global $_COOKIE;
	if(!isset($_COOKIE['popcontact'])) setcookie('popcontact','t',0,'/');	
}
add_action('init','pop_cookie');

add_action('wp_head','sb_contact_ajaxurl');

function sb_contact_ajaxurl() {

?>

<script type="text/javascript">

window.ajaxurl_contact = "<?php echo admin_url('admin-ajax.php'); ?>";

</script>

<?php

}

function sb_contact_admin_javascript() {
?>

<script type="text/javascript" >

jQuery(document).ready(function($) {

	$("#sbContactForm, #sbPopContactForm").validate({
						errorPlacement: function(error, element) {
							error.insertAfter(element);
						}	,
						errorElement: "span",
						highlight: function(element, errorClass, validClass) {
							$(element).addClass(errorClass).removeClass(validClass);
							//$(element.form).find("label[for=" + element.id + "]").addClass(errorClass);
						},
						unhighlight: function(element, errorClass, validClass) {
							$(element).removeClass(errorClass).addClass(validClass);
							//$(element.form).find("label[for=" + element.id + "]").removeClass(errorClass);
						}
					});
					$.validator.messages.required = "";
					
				
					$("#sbContactButton").click(function() {
						if($("#sbContactForm").valid()) {
							//$("#sbContactWrapper .thanksBox").show("slide",{direction:"right"});
							$("#sbContactWrapper .thanksBox").fadeIn(500);
							$("#sbContactForm input, #sbContactForm select, #sbContactForm textarea").each(function() {
								$(this).attr("disabled","disabled");
							});
							
							$("#sbContactButton").addClass("hideMe");
							
							var data = {
					
								action: "sbcon_get_data",
					
								datatype: "sbContactus",
					
								name: $("#form_name").val(),
					
								email: $("#form_email").val(),
								
								message: $("#form_message").val()
					
							};
					
					
					
							$.post(ajaxurl_contact, data, function(data) {
								
								if(data != "error") {	
									
									$("#sbContactForm")[0].reset();
									$("#sbContactForm input, #sbContactForm select, #sbContactForm textarea").each(function() {
										$(this).removeAttr("disabled");
									});
									thanksTimer();
								}
							});
						}
				
					});
					
					function thanksTimer() {
						setTimeout(function() {
								//$("#sbContactSubmitting").addClass("hideMe");
								$("#sbContactButton").removeClass("hideMe");
								//$("#sbContactWrapper .thanksBox").hide("slide",{direction:"right"});
								$("#sbContactWrapper .thanksBox").fadeOut(1000);
								//$("#sbContactWrapper .formBox").show("slide",{direction:"up"});
								//$("#sbContactWrapper .formBox").show();
							  
						}, 8000);
					}
					
					$("#sbPopContactButton").click(function() {
						if($("#sbPopContactForm").valid()) {
							//$("#sbContactWrapper .thanksBox").show("slide",{direction:"right"});
							$("#sbPopContactWrapper .form").hide();
							$("#sbPopContactWrapper .thanksBox").show();
							$("#sbPopContactForm input, #sbPopContactForm select, #sbPopContactForm textarea").each(function() {
								$(this).attr("disabled","disabled");
							});
							
							//$("#sbContactButton").addClass("hideMe");
							
							var data = {
					
								action: "sbcon_get_data",
					
								datatype: "sbPopContactus",
					
								name: $("#pop_form_name").val(),
					
								email: $("#pop_form_email").val()
					
							};
					
					
					
							$.post(ajaxurl_contact, data, function(data) {
								
								if(data != "error") {	
									
									$("#sbPopContactForm")[0].reset();
									$("#sbPopContactForm input, #sbPopContactForm select, #sbPopContactForm textarea").each(function() {
										$(this).removeAttr("disabled");
									});
									$.cookie("popcontact", 'f');
									//thanksPopTimer();
								}
							});
						}
				
					});
					
					$('#sbPopContactWrapper .close').on('click',function() {
						$('.formOverlay').css('display','none');
					});
					
					setTimeout(function() {
								$('.formOverlay').css('display','block');
							  
						}, 2000);
					

} );

</script>



<?php



}

function sbcon_get_data_callback() {

	global $wpdb; 

	include(plugin_dir_path( __FILE__ ) . 'includes/data.php');
	
	die(); 



}
// allow ajax no priv and admin
add_action('wp_ajax_nopriv_sbcon_get_data', 'sbcon_get_data_callback');
add_action('wp_ajax_sbcon_get_data', 'sbcon_get_data_callback');


// widget setup
add_action( 'widgets_init', 'sb_widget_contact_form_function' );

function sb_widget_contact_form_function() {

	register_widget( 'sb_widget_contact_form' );

}

class sb_widget_contact_form extends WP_Widget {

	public function __construct() {
	
		parent::__construct(
	
			'sb_widget_contact_form',
			__( 'Contact Form', 'sb_widget_contact_form' ),
			array(
				'classname'   => 'sb_widget_contact_form',
				'description' => __( 'Display contact form', 'sb_widget_contact_form' )
			)
	
		);
	
	}

	// Display widget

	function widget( $args, $instance ) {

		echo sbContact_function();

	}

}


?>