<?php
// Theme Functions

// Setup
function nstore_setup() {
	add_editor_style();
	
	//Register Navigation
	register_nav_menu( 'main-nav-1', __( 'Main Top Nav 1', 'nstore' ) );
	register_nav_menu( 'home-blocks', __( 'Home Page Blocks', 'nstore' ) );
	register_nav_menu( 'footer-nav-1', __( 'Footer Nav 1', 'nstore' ) );
	
	add_theme_support( 'post-thumbnails' );
	set_post_thumbnail_size( 604, 270, true );
	add_image_size( 'page-image-max', 750, 9999 ); 
	add_image_size( 'blog-image-max', 570, 9999 );  

}
add_action( 'after_setup_theme', 'nstore_setup' );

function nstore_custom_sizes( $sizes ) {
	unset($sizes['large']);
    return array_merge( $sizes, array(
        'page-image-max' => __('Page Max Width'),
		'blog-image-max' => __('Blog Max Width')
    ) );
}
add_filter( 'image_size_names_choose', 'nstore_custom_sizes' );

// Basic Styles and Scripts
function nstore_scripts_styles() {

	wp_enqueue_script('jquery-effects-slide');
	wp_enqueue_script( 'sb-script', get_template_directory_uri() . '/js/functions.js', array( 'jquery' ), '2013-07-18', true );
	
	wp_enqueue_style( 'sb-style2', get_template_directory_uri() . '/style.css?v=14' );
	wp_enqueue_style( 'sb-mobile-style2', get_template_directory_uri() . '/mobile.css?v=14' );

	
}
add_action( 'wp_enqueue_scripts', 'nstore_scripts_styles' );

//Set Widgets
function nstore_widgets_init() {
	register_sidebar( array(
		'name' => __( 'Sidebar Widgets', 'nstore' ),
		'id' => 'sidebar-widgets',
		'description' => __( 'Appears at right of content', 'nstore' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
	
	register_sidebar( array(
		'name' => __( 'Footer Widget', 'nstore' ),
		'id' => 'footer-widgets',
		'description' => __( 'Appears in footer of all pages.', 'nstore' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
}
add_action( 'widgets_init', 'nstore_widgets_init' );


if ( ! function_exists( 'nstore_paging_nav' ) ) :
/**
 * Displays navigation to next/previous set of posts when applicable.
 */
function nstore_paging_nav() {
	global $wp_query;

	// Don't print empty markup if there's only one page.
	if ( $wp_query->max_num_pages < 2 )
		return;
	?>
	<nav class="navigation paging-navigation" role="navigation">
		<h1 class="screen-reader-text"><?php _e( 'Posts navigation', 'nstore' ); ?></h1>
		<div class="nav-links">

			<?php if ( get_next_posts_link() ) : ?>
			<div class="nav-previous"><?php next_posts_link( __( '<span class="meta-nav">&larr;</span> Older posts', 'nstore' ) ); ?></div>
			<?php endif; ?>

			<?php if ( get_previous_posts_link() ) : ?>
			<div class="nav-next"><?php previous_posts_link( __( 'Newer posts <span class="meta-nav">&rarr;</span>', 'nstore' ) ); ?></div>
			<?php endif; ?>

		</div><!-- .nav-links -->
	</nav><!-- .navigation -->
	<?php
}
endif;

if ( ! function_exists( 'nstore_post_nav' ) ) :
/**
 * Displays navigation to next/previous post when applicable.
*/
function nstore_post_nav() {
	global $post;

	// Don't print empty markup if there's nowhere to navigate.
	$previous = ( is_attachment() ) ? get_post( $post->post_parent ) : get_adjacent_post( false, '', true );
	$next     = get_adjacent_post( false, '', false );

	if ( ! $next && ! $previous )
		return;
	?>
	<nav class="navigation post-navigation" role="navigation">
		<h1 class="screen-reader-text"><?php _e( 'Post navigation', 'nstore' ); ?></h1>
		<div class="nav-links">

			<?php previous_post_link( '%link', _x( '<span class="meta-nav">&larr;</span> %title', 'Previous post link', 'nstore' ) ); ?>
			<?php next_post_link( '%link', _x( '%title <span class="meta-nav">&rarr;</span>', 'Next post link', 'nstore' ) ); ?>

		</div><!-- .nav-links -->
	</nav><!-- .navigation -->
	<?php
}
endif;

if ( ! function_exists( 'nstore_entry_meta' ) ) :

function nstore_entry_meta() {
	if ( is_sticky() && is_home() && ! is_paged() )
		echo '<span class="featured-post">' . __( 'Sticky', 'nstore' ) . '</span>';

	if ( ! has_post_format( 'link' ) && 'post' == get_post_type() )
		nstore_entry_date();

	// Translators: used between list items, there is a space after the comma.
	$categories_list = get_the_category_list( __( ', ', 'nstore' ) );
	if ( $categories_list ) {
		//echo '<span class="categories-links">' . $categories_list . '</span>';
	}

	// Translators: used between list items, there is a space after the comma.
	$tag_list = get_the_tag_list( '', __( ', ', 'nstore' ) );
	if ( $tag_list ) {
		echo '<span class="tags-links">' . $tag_list . '</span>';
	}

	// Post author
	if ( 'post' == get_post_type() ) {
		/*
		printf( '<span class="author vcard"><a class="url fn n" href="%1$s" title="%2$s" rel="author">%3$s</a></span>',
			esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
			esc_attr( sprintf( __( 'View all posts by %s', 'nstore' ), get_the_author() ) ),
			get_the_author()
		);
		*/
	}
}
endif;

if ( ! function_exists( 'nstore_entry_date' ) ) :

function nstore_entry_date( $echo = true ) {
	if ( has_post_format( array( 'chat', 'status' ) ) )
		$format_prefix = _x( '%1$s on %2$s', '1: post format name. 2: date', 'nstore' );
	else
		$format_prefix = '%2$s';

	$date = sprintf( '<span class="date"><time class="entry-date" datetime="%3$s">%4$s</time></span>',
		esc_url( get_permalink() ),
		esc_attr( sprintf( __( 'Permalink to %s', 'nstore' ), the_title_attribute( 'echo=0' ) ) ),
		esc_attr( get_the_date( 'c' ) ),
		esc_html( sprintf( $format_prefix, get_post_format_string( get_post_format() ), get_the_date() ) )
	);

	if ( $echo )
		echo $date;

	return $date;
}
endif;

// If page, use parent template
function switch_page_template(){

        global $post;

        if(is_page()){// Checks if current post type is a page, rather than a post
        
                $current_page_template = get_post_meta($post->ID,'_wp_page_template',true);
                $parent_page_template = get_post_meta($post->post_parent,'_wp_page_template',true);
                $parents = get_post_ancestors($post->ID);
                
                if($parents){
                        update_post_meta($post->ID,'_wp_page_template',$parent_page_template,$current_page_template);
                }
        
        }// End check for page
}
add_action('save_post','switch_page_template');

//remove random p tags in pages
//remove_filter( 'the_content', 'wpautop' );


?>